### 1. Why CASB is Needed

- **Cloud and SaaS Adoption:**
    - Increased use of cloud apps and mobile workforces challenges enforcement of corporate security policies.
    - Users may bypass traditional security infrastructure when accessing third-party SaaS applications.
- **CASB’s Role:**
    - Protects users, data, and cloud applications—regardless of user location or device.
    - Focuses on securing cloud environments, filling gaps that endpoint and network-based security can’t cover.
    - Offers visibility and control where SaaS providers may lack customer-facing security features.

---

### 2. Limitations Without CASB

- **Visibility Gaps:**
    - Traditional endpoint and network security may not monitor SaaS usage effectively.
    - SaaS providers may not provide behavioral analytics or allow infrastructure-level controls.
- **Security Effectiveness Gap:**
    - Adding multiple security microservices (like UEBA, DLP, App Firewall) increases complexity.
    - Managing numerous security products for each SaaS environment can become unmanageable.

---

### 3. CASB Solution Benefits

- **Unified Platform:**
    - API-based CASB closes the security effectiveness gap by integrating multiple security services (e.g., DLP, analytics, auditing) through a single tool.
    - CASB provides a consistent management interface for multiple SaaS environments.
- **No User/Cloud Service Disruption:**
    - Users access cloud apps as usual; cloud providers operate as normal.
    - CASB operates transparently, often out-of-band.

---

### 4. CASB Architectures

#### **A. Inline Deployment**
![[Pasted image 20250921161908.png]]

- **Reverse Proxy:**
    - Placed in front of the cloud resource, inspects traffic as users connect.
- **Forward Proxy:**
    - Placed closer to the user, inspects outbound connections to cloud resources.
- **Pros:**
    - Fast reaction to threats; supports extra services (traffic engineering, deep-packet inspection).
- **Cons:**
    - Can interrupt data path if CASB service fails.
    - Limited scope—may not secure cloud-to-cloud traffic or unmanaged devices.

#### **B. Out-of-Band Deployment**
![[Pasted image 20250921162017.png]]

- **API-Based CASB:**
    - Integrates with cloud apps via APIs to monitor and control usage.
    - Enables security for cloud-to-cloud traffic and unmanaged devices.
    - Supports retrospective analytics and DLP on data at rest.
- **Log-Based CASB:**
    - Relies on log ingestion and SIEM tools; slower response.
- **Pros:**
    - Broader visibility, works independently of user location or device.
    - No disruption to the application or user experience.
- **Cons:**
    - Log-based approach may delay detection and response.

---

### 5. CASB Capabilities

- **Common Security Microservices:**
    - User behavior analytics (UEBA)
    - Data loss prevention (DLP)
    - Auditing and reporting
    - Application firewalling
- **Centralized Management:**
    - Reduces complexity by managing security for multiple SaaS apps through a single interface.

---

**Key Takeaways:**

- CASB solutions are essential for securing SaaS application usage in modern, mobile, cloud-focused enterprises.
- They provide visibility, control, and advanced security capabilities where traditional security tools fall short.
- CASBs are available as inline (proxy-based) or out-of-band (API/log-based) deployments, each with unique strengths and limitations.
- API-based out-of-band CASB offers the broadest coverage and least disruption, ideal for diverse and dynamic cloud environments.